varying vec2 f_texcoord;

uniform sampler2D texture;
uniform float factor;


void main(void)
{
	vec3 colorResult = texture2D(texture, f_texcoord).rgb;

	const vec3 lumFactor = vec3(0.7, 0.1, 0.2);
	const float brightness = 0.4;
	float luminance = dot(lumFactor, colorResult) * brightness;


	const float edgeFactor1 = 0.5;
	const float edgeFactor2 = 1.2;
	const float avoidZero = 0.01;
	float colGB = (colorResult.g + colorResult.b);
	float edge1 = edgeFactor1 * colGB;
	float edge2 = edgeFactor2 * colGB + avoidZero;
	float redFactor = clamp((colorResult.r-edge1)/(edge2-edge1), 0.0, 1.0);

	const float redFactorBase = 0.25;
	const float redFactorMin = 0.18;
	const float luminenceMin = 0.2;

	luminance *= mix(1.0, luminenceMin, redFactor);
	float red = mix(luminance, min(redFactorMin, colorResult.r*redFactorBase), redFactor);


	vec3 colorBR = vec3(red, luminance, luminance);
	colorResult = mix(colorResult, colorBR, factor);

	gl_FragColor = vec4(colorResult, 1.0);
}
